<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateKelulusanTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nisn' => [
                'type'       => 'VARCHAR',
                'constraint' => 20,
            ],
            'nama' => [
                'type'       => 'VARCHAR',
                'constraint' => 150,
            ],
            'kelas' => [
                'type'       => 'VARCHAR',
                'constraint' => 50,
            ],
            'tgl_lahir' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'status' => [
                'type'       => 'ENUM',
                'constraint' => ['LULUS','TIDAK LULUS'],
                'default'    => 'LULUS',
            ],
            'keterangan' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'skl_file' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
            ],
            'is_active' => [
                'type'       => 'TINYINT',
                'constraint' => 1,
                'default'    => 1,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addKey('nisn', false, true); // UNIQUE
        $this->forge->createTable('kelulusan');
    }

    public function down()
    {
        $this->forge->dropTable('kelulusan');
    }
}
